export type Technician = {
  id: string;
  name: string | null;
  email: string;
  hourlyRate: number | null;
  createdAt: string;
  isExternal?: boolean;
  companyName?: string | null;
};

export type CostAnalysisData = {
  summary: {
    totalTickets: number;
    totalHours: number;
    totalCost: number;
    technicianCount: number;
  };
  technicians: {
    technicianId: string;
    technicianName: string;
    technicianEmail: string;
    hourlyRate: number;
    isExternal?: boolean;
    companyName?: string | null;
    totalTickets: number;
    totalHours: number;
    totalCost: number;
  }[];
  tickets: any[];
};

export type SystemAnalysisData = {
  ticketStats: {
    totalTickets: number;
    openTickets: number;
    inProgressTickets: number;
    completedTickets: number;
    closedTickets: number;
    averageResolutionTime: number;
  };
  departmentStats: {
    department: string;
    ticketCount: number;
    avgSeverity: number;
    avgResolutionTime: number;
    duplicateCount: number;
    duplicatePercentage: number;
  }[];
  severityStats: {
    severity: number;
    count: number;
    avgResolutionTime: number;
  }[];
  technicianStats: {
    technicianId: string;
    technicianName: string;
    totalTickets: number;
    avgResolutionTime: number;
    completionRate: number;
  }[];
  timeStats: {
    todayTickets: number;
    weekTickets: number;
    monthTickets: number;
    avgTicketsPerDay: number;
  };
};

export type TabId =
  | "overview"
  | "costs"
  | "performance"
  | "departments"
  | "kpi";
